#ifndef LZ_MATH_GLSL
#define LZ_MATH_GLSL

/*
math.glsl
Helper functions implementing various math related operations
*/
#ifndef PI
#define PI 3.1415926535897932384626433832795028841971693993751058209749445923078164062
#define DPI 3.1415926535897932384626433832795028841971693993751058209749445923078164062 * 2.0
#define PIH 3.1415926535897932384626433832795028841971693993751058209749445923078164062 * 0.5
#endif
//Generates a perspective matrix given common perspective parameters
mat4 CreatePerspectiveMatrix(float fov, float aspect, float near, float far) {
	mat4 m = mat4(0.0);

	float angle = (fov / 180.0f) * PI;
	float f = 1.0f / tan(angle * 0.5f);

	m[0][0] = f / aspect;
	m[1][1] = f;
	m[2][2] = (far + near) / (near - far);
	m[2][3] = -1.0f;
	m[3][2] = (2.0f * far*near) / (near - far);

	return m;
}

//Generates a rotation matrix given an axis and angle in radians
mat4 CreateRotationMatrix(vec3 axis, float angle) {
	axis = normalize(axis);
	float s = sin(angle);
	float c = cos(angle);
	float oc = 1.0 - c;

	return mat4(oc * axis.x * axis.x + c, oc * axis.x * axis.y - axis.z * s, oc * axis.z * axis.x + axis.y * s, 0.0,
				oc * axis.x * axis.y + axis.z * s, oc * axis.y * axis.y + c, oc * axis.y * axis.z - axis.x * s, 0.0,
				oc * axis.z * axis.x - axis.y * s, oc * axis.y * axis.z + axis.x * s, oc * axis.z * axis.z + c, 0.0,
				0.0, 0.0, 0.0, 1.0);
}

mat2 CreationRotationMatrix2D(float angle) {
	return mat2(cos(angle), -sin(angle),
				sin(angle), cos(angle));
}

/*
* math.glsl end
*/
#endif